/*      Copyright (c) 1987 Shrier and Deihl. Licensed to Mix Software, Inc.
        Copyright (c) 1996 Mix Software, Inc. Multi-user version

        isamlib.h - INTERNAL include file for ISAM function library

        This include file used only by the internal routines of the
        ISAM package, not by the user.
*/
#define CDT_SRC         1
#define ISAM_SRC        1
#define USE_ACCESS      1
#define BUFFERED_WRITE  1
#define I_PFX_INDEX    0
#define I_PFX_OFFSET   0xFE
#define I_PFX_SIZE     0xFF
#define MAX_INDEXNBR   0xFF
#define MAX_INT        0x7FFF
#define I_A_READLOCK   0x01
#define I_A_WRITELOCK  0x02
#define I_M_READLOCK   0x04
#define I_M_WRITELOCK  0x08
#define I_X_WRITELOCK  0x0A
#define I_X_READLOCK   0x05
#define MIN_REC_LIMIT  32

#include "cbtree.h"
#include "isamerr.h"

#if defined(DEBUG)
   #define I_ASSERT(exp) if (!(exp)) B_assert_msg(__FILE__, __LINE__)
   extern void B_assert_msg(char *file, int line);
#else
   #define I_ASSERT(exp)
#endif
#if defined(I_UNIX)
   #define stricmp(s1, s2) strcasecmp(s1, s2)
   extern int memicmp(const void *s1, const void *s2, size_t len);
#endif

typedef short Rec_Len;        /* record length stored on disk */
typedef long Ptr;             /* ptr to record in datafile */

I_EXPORT_DATA int isam_errno; /* global error number variable */

typedef struct s_lock_data {  /* description of a locked record */
   struct s_lock_data *next;  /* next lock in list */
   Lock_Handle handle;        /* lock id */
   Ptr location;              /* starting address */
   } Lock_Info;

typedef struct s_db_obj {
   struct s_db_obj *next; /* next valid Db_Obj */

   /* info about the data file */
   char *data_filename; /* name of data file */
   int fd;              /* file descriptor of open data file */
   Rec_Len field_count; /* nbr of fields in a record */
   char **field_names;  /* ptr to argv-style ptrs to field names */
   char *field_buf;     /* buffer for field names */
   long first_rec;      /* addr of first record */
   char *field_type;    /* type of each field in record
                           0:string, 1:case sensitive string,
                           2:int, 3:unsigned, 4:long,
                           5:float, 6:double */
   Rec_Len *field_len;  /* length of each field in record
                           used for binary fields only (type B) */
   int min_rec_size;    /* minimum record size */
   int readonly;        /* file opened read only */
   int share;           /* file is shared */
   int locked;          /* locking status for entire file */

   /* info about the index file */
   char *index_filename;/* name of index file */
   Cbtree *desc_tree;   /* tree that describes the indexes */
   Cbtree *hole_tree;   /* tree describing holes in the datafile */
   int index_count;     /* nbr of indexes in the db */
   struct s_index_obj *index_list; /* list of indexes from db */
   Lock_Info  locks;    /* list of locked records */
   Ptr liblock;         /* internal record lock for library use */
   /* The physical index is a psuedo-index, not stored in the
      indexfile.  This pointer keeps track of the current record by the
      physical index. NO_CURRENT means BOI and/or no current record */
   Ptr phys_ptr;       /* current record in physical index */
   } Db_Obj;

typedef struct s_rec_info {
   char *rec_buffer;    /* buffer holding the record */
   Rec_Len rec_length;  /* length of record in rec_buffer */
   char **fields;       /* ptrs to fields in record */
   } Rec_Info;

typedef struct s_key_info {
   char *key_buf;      /* buffer holding the key */
   int key_buf_len;    /* length of the key_buf itself */
   int key_len;        /* length of key now in key_buf */
   } Key_Info;
/**/

typedef struct s_seg_info {
   int start;
   int length;
   } Seg_Info;

typedef struct s_index_obj {
   struct s_index_obj *next;  /* next index for this database */
   int index_nbr;             /* prepended to all keys */
   char *index_name;          /* name of this index */
   Cbtree *tree;              /* tree for this index */
   Db_Obj *db;                /* data base that this index attached to */
   int field_count;           /* number of fields in a key */
   int *field_nbrs;           /* list of field numbers that make the key */
   char unique;               /* flag for unique (no duplicates) */
   Seg_Info *field_segs;      /* field segments for segmented keys */

   /* Since the Isam maintains all indexes for a database in one
      indexfile, the Isam's notion of BOI and EOI is not necessarily
      the same as CBT's notion.  This variable keeps Isam's notion. */
   int position_status;       /* BOI, EOI, OK */
   } Index_Obj;
#define NO_CURRENT      0       /* no current record by physical index */
#define PHYSICAL_INDEX  0       /* index_nbr of the physical index */

#include "member.h"
#include "isam.h"
#if defined(isam_errno)
   #undef isam_errno
#endif
#if defined(cbconcode)
   #undef cbconcode
   #undef cbfcncode
   #undef cberrcode
   I_EXPORT_DATA int cbconcode;  /* context code - what it was doing */
   I_EXPORT_DATA int cbfcncode;  /* function code - who detected the error */
   I_EXPORT_DATA int cberrcode;  /* error code - the error itself */
#endif

/*
        global variables used internal to the ISAM package
        (defined in isaminit.c)
*/

extern unsigned char I_pfx_index;      /* prefix for index name in index */
extern unsigned char I_pfx_size;       /* prefix for size delete list */
extern unsigned char I_pfx_offset;     /* prefix for offset delete list */
extern int  I_msb_first;      /* byte order for integers */
extern Db_Obj *I_db_objs;     /* set of valid db objects */
extern Db_Obj *I_db_object;   /* current db object used by I_compare() */
extern Db_Obj *I_db_last;     /* last db object used by I_compare() */
extern Key_Info I_db_key;     /* temp storage for key during internal use */

extern Progress_Fn_Ptr I_progress;  /* pointer to function called after each */
                              /* record procesed by imkindex, irmindex, */
                              /* or icopy_db. */
extern int  I_lock_tries;     /* number of attempts to lock the file */
extern long I_lock_delay;     /* delay between locking attempts (millisec) */
extern long I_lock_timeout;   /* lock time out (millisec) */
#define  I_OS_DOS   1
#define  I_OS_MSWIN 2
#define  I_OS_OS2   3
#define  I_OS_UNIX  4
extern int  I_operating_system;  /* initialized for which environment */

#include "ismproto.h"

/* use simpler names for error and success */
#if defined(ERROR)
   #undef ERROR
#endif
#define ERROR CBT_ERROR
#if defined(OK)
   #undef OK
#endif
#define OK CBT_OK

/* error code macros */
#if defined(WIN16_DLL)
   #define SET_EC(code) *(_isam_inst->isam_errno) = code;
   #define ERRX(code)  {*(_isam_inst->isam_errno) = code; return I_ERROR;}
   #define GET_EC       *(_isam_inst->isam_errno)
#else
   #define SET_EC(code) isam_errno = code;
   #define ERRX(code)  {isam_errno = code; return I_ERROR;}
   #define GET_EC       isam_errno
#endif

/* end isamlib.h */
