/*.     Copyright (c) 1987 Shrier and Deihl. Licensed to Mix Software, Inc.
        Copyright (c) 1994 Mix Software, Inc. Multi-user version

        dbhandle.c - ISAM idbhandle function
*/
#include "isamlib.h"
#include "filename.h"
#include <string.h>
#if defined(I_UNIX)
#include <sys/types.h>
#include <sys/stat.h>
#endif
/*
        Defined Functions

        idbhandle               return handle of an open database
*/
/*
        idbhandle - return handle for open database

        Returns handle of the database if it is open,
        or NULL if the database is not currently open.
*/

I_EXPORT Db_Obj * I_ENTRY idbhandle(const char *db_name)
{
   Db_Obj *db;
#if defined(I_UNIX)
   struct stat cur, test;
#endif
   
   char data_filename[MAX_FILENAME + 1];
   if (I_mkdata_filename(db_name, data_filename, MAX_FILENAME) == NULL) {
      SET_EC(I_MAKENAME)
      return (NULL);
      }
#if !defined(I_UNIX)
   for (db = I_db_objs; db != NULL; db = db->next) {
      if (strcmp(db->data_filename, data_filename) == 0) return (db);
      }
#else
   if (stat(data_filename, &cur) != 0) return (NULL);  /* no file */
   for (db = I_db_objs; db != NULL; db = db->next) {
      if (fstat(db->fd, &test) == 0 && cur.st_ino == test.st_ino
         && cur.st_dev == test.st_dev) return (db);
      }
#endif
   return (NULL);
   } /* idbhandle */

/* end dbhandle.c */
