/*      Copyright (c) 1994 Mix Software, Inc.
        cblock.c - Lock or unlock the btree
*/
#include "btree.h"
#include "ctlrec.h"

/*      Defined Functions
        cblock          lock the tree
        cbunlock        unlock the tree
        cblock_timeout  set lock tries and timeout
*/

/*      cblock - lock the file for reading or writing
        Returns I_OK, I_BUSY or I_ERROR
*/

I_EXPORT int I_ENTRY cblock(Cbtree *tree, int lock_type)
{
   int status;                 /* subroutine return status */
   Ctlrec *ctl;

   SET_FC(FC_CBLOCK)
   if ((B_is_tree_valid(tree) == I_NO) || (B_is_ctl_valid(tree->ctl) == I_NO))
      return (I_ERROR);
   ctl = tree->ctl;
   if (lock_type == I_READLOCK) {
      status = B_read_lock(tree->ctl);
      if (status == I_OK) {
         ctl->lock_state |= CTL_MANUAL_READ_LOCK;
         return I_OK;
         }
      if (GET_EC == EC_LOCK) return I_BUSY;
      return I_ERROR;
      }
   /* write lock */
   if (lock_type == I_WRITELOCK) {
      status = B_write_lock(tree->ctl);
      if (status == I_OK) {
         ctl->lock_state |= CTL_MANUAL_WRITE_LOCK;
         return I_OK;
         }
      if (GET_EC == EC_LOCK) return I_BUSY;
      }
   return I_ERROR;
   }

/*      cbunlock - unlock the file for reading or writing
        Returns OK or ERROR
*/

I_EXPORT int I_ENTRY cbunlock(Cbtree *tree, int lock_type)
{
   Ctlrec *ctl;

   SET_FC(FC_CBUNLOCK)
   if ((B_is_tree_valid(tree) == I_NO) || (B_is_ctl_valid(tree->ctl) == I_NO))
      return (I_ERROR);
   ctl = tree->ctl;
   if (lock_type == I_READLOCK) {
      if ((ctl->lock_state & CTL_RLOCK) == CTL_MANUAL_READ_LOCK) {
         if (ctl->lock_state & CTL_MANUAL_WRITE_LOCK) {
            ctl->lock_state = (ctl->lock_state & ~CTL_MANUAL_READ_LOCK);
            return I_OK;
            }
         ctl->lock_state = (ctl->lock_state & ~CTL_RLOCK) | CTL_AUTO_READ_LOCK;
         return B_ctl_unlock(ctl);
         }
      return I_OK;
      }

   if (lock_type == I_WRITELOCK) {
      if ((ctl->lock_state & CTL_MANUAL_WRITE_LOCK) == CTL_MANUAL_WRITE_LOCK) {
         /* if write locked, clear flag & write any changes to disk */
         if (ctl->modified) B_ctl_resync(ctl, I_NO, I_NO);
         ctl->lock_state = (ctl->lock_state & ~CTL_MANUAL_WRITE_LOCK);
         CB_ASSERT(ctl->modified == 0);
         /* if not also auto write locked, remove the lock */
         if ((ctl->lock_state & CTL_AUTO_WRITE_LOCK) != CTL_AUTO_WRITE_LOCK) {
            ctl->lock_state = (ctl->lock_state & ~CTL_WLOCK) | CTL_AUTO_WRITE_LOCK;
            return B_ctl_unlock(ctl);
            }
         }
      return I_OK;
      }
   return I_ERROR;
   }

/*      cblock_timeout - set try count and timeout for file locking
        Returns nothing
*/

I_EXPORT void I_ENTRY cblock_timeout(int tries, long delay, long timeout)
{
   _cb_lock_tries = tries;
   _cb_lock_delay = delay;
   _cb_lock_timeout = timeout;
   return;
   }

