/*      Copyright (c) 1987 Shrier and Deihl. Licensed to Mix Software, Inc.
        Copyright (c) 1995 Mix Software, multi-user version

        cbflush.c - CBT cbflush function
*/
#include "btree.h"
#include "blockio.h"

/*      Defined Functions
        cbflush         flush all nodes to disk
*/

/*      cbflush - flush dirty buffers and control record for a file to disk

        Even if there are no buffers to be written, the control record is
        always written and the date/time stamp on the index file is updated
        ("touched").  Cbclose and cbexit automatically perform this function.

        Returns OK or ERROR.
*/
#define MANUAL_WRITE_LOCK(ctl) ((ctl->lock_state & CTL_WLOCK) == CTL_MANUAL_WRITE_LOCK)

I_EXPORT int I_ENTRY cbflush(Cbtree *tree)
{
   Ctlrec *ctl;         /* control record for this file */

   SET_FC(FC_CBFLUSH)
   ctl = tree->ctl;
   if ((B_is_tree_valid(tree) == I_NO) || (B_is_ctl_valid(ctl) == I_NO))
      return (I_ERROR);
   return (B_flush(tree));
   } /* cbflush */

/*
        _b_flush - flush all buffers and write control record
        Return OK or ERROR.
*/

int B_flush(Cbtree *tree)
{
   Ctlrec *ctl;        /* control record for this file */
   Bfile  *bfile;      /* buffered file pointer */
   int tries;          /* count of locking attempts */
   int errcode;        /* temp value of cberrcode */
   int concode;        /* temp value of cbconcode */
   int wlock, status;

   errcode = EC_NOERR;
   concode = CC_NOCON;
   SET_EC(errcode)
   SET_CC(concode)
   ctl = tree->ctl;
   bfile = ctl->bfile;
   CB_ASSERT(B_is_tree_valid(tree) == I_YES && B_is_ctl_valid(ctl) == I_YES);

   if (bfile->status != CB_FILE_RDONLY) { /* file has been written to */
      wlock = MANUAL_WRITE_LOCK(ctl);
      if (ctl->share == 0 || wlock) {     /* exclusive access */
         if (ctl->modified) status = B_ctl_resync(ctl, I_NO, I_NO);
         else status = B_ctlsave(ctl);
         if (status == I_ERROR) {
            errcode = GET_EC;
            concode = GET_CC;
            }
         }
      if (ctl->share == 0 || B_need_to_flush(bfile)) {
         if (ctl->share != 0) {
            tries = MAX_LOCK_TRIES;
            while (tries--) {
               if ((errcode = B_write_lock(ctl)) == I_OK) break;
               _cb_delay(LOCK_DELAY);
               }
            if (errcode == I_ERROR) {   /* if we can't lock, we can't update */
               SET_CC(CC_LOCK)          /* return to caller to allow retry   */
               return (I_ERROR);
               }
            }
         CB_ASSERT(ctl->share == 0 || wlock);
         if (flush_blks(bfile) == I_ERROR) {
            errcode = EC_FLUSHBLKS;
            concode = CC_FLUSHBTREE;
            }
         if (_cb_commitblk(bfile->fd) == I_ERROR) {
            errcode = EC_FLUSHBLKS;
            concode = CC_FLUSHBTREE;
            }
         B_ctl_unlock(ctl);   /* release automatic locks */
         }
      bfile->status = CB_FILE_RDONLY;
      }
   SET_EC(errcode)
   if (errcode == EC_NOERR) return (I_OK);
   SET_CC(concode)
   return (I_ERROR);
   } /* _b_flush */

/* end cbflush.c */
